<?php

include('pdf/fpdf.php');
session_cache_limiter('private');
session_start();
$com = "I";
include("DMMYSQLG.php");
include("DSA3000.php");
include("DMMYSQLG.php");
include('DF80000.php');
 
class PDF extends FPDF{
	//Cabecera de Pgina
	function Header(){
	    //Logotipo
	    include("DYIM_VER.php");
	    //Arial Bold (14)
	    $this->SetFont('Arial','B',12);
	    //Espacio
		
	    //Ttulo
		if($_POST['setipven']!='TODAS'){
			$dt_tipven = mysqli_fetch_array(mysqli_query($GLOBALS['con'] ,"select * from dgtipven where tip_ven='".$_POST['setipven']."'"));
			$tipoventa=$dt_tipven["des_tipven"];
		}
		else
			$tipoventa="TODAS";
	    $this->Cell(250,3,'REPORTE LISTADO DE VENTAS X CLIENTE',0,1,'C');
		$this->SetFont('Arial','B',8);
		$this->Cell(250,3,'Del '.$_POST['fecini'].' al '.$_POST['fecfin'].' ('.$tipoventa.')',0,1,'C');
	    //Salto de lnea
	    $this->Ln(3);
		$this->SetFont('Times','',8);
		$this->SetFillColor(220,220,220);
		$this->Cell(8,3,'',0,0,'C');
		$this->Cell(17,3,'Factura',1,0,'C',1);
		$this->Cell(20,3,'Num.Parte',1,0,'C',1);
		$this->Cell(65,3,'Descrip.',1,0,'C',1);
		$this->Cell(15,3,'Clave/Ven',1,0,'C',1);
		$this->Cell(10,3,'Can.',1,0,'C',1);
		$this->Cell(17,3,'Precio Unita.',1,0,'C',1);
		$this->Cell(17,3,'Importe',1,0,'C',1);
		$this->Cell(17,3,'I.V.A',1,0,'C',1);
		$this->Cell(17,3,'Total Fac.',1,0,'C',1);
		$this->Cell(15,3,'Costo Unita.',1,0,'C',1);
		$this->Cell(17,3,'Costo Total',1,0,'C',1);
		$this->Cell(15,3,'Utilidad',1,0,'C',1);
		$this->Cell(17,3,'% Utilidad',1,1,'C',1);
	}
	//Pie de Pgina
	function Footer()
	{
	    //Posicin: 1,5 cm del Final
	    $this->SetY(-15);
	    //Arial Italic 8
	    $this->SetFont('Arial','I',8);
	    //Nmero de pgina
	    $this->Cell(0,0, $this->PageNo().'/{nb}',0,0,'C');
	}
}
$pdf;

$pdf=new PDF('L','mm','A4');
$pdf->AddPage();
$pdf->AliasNbPages();
$binit=-1;
$pdf->SetFillColor(240,240,240);
$pdf->SetFont('Arial','',8);
$sq_factudmix=mysqli_query($GLOBALS['con'] ,$_POST['sbus']);
while(@$dt_factudmix=mysqli_fetch_array($sq_factudmix)){
	if($binit==-1){ 
		$binit=1;
		$bfac=$dt_factudmix["num_fac"];
		imp_head($dt_factudmix);
		$bhead=$dt_factudmix["tip_ven"].$dt_factudmix["fec_fac"];
	}
	elseif($bhead!=$dt_factudmix["tip_ven"].$dt_factudmix["fec_fac"]){
		imp_foot($bfac,$TotFac);
		impLn();
		imp_head($dt_factudmix);
		$bhead=$dt_factudmix["tip_ven"].$dt_factudmix["fec_fac"];
		$bfac=$dt_factudmix["num_fac"];
	}
	if($bfac!=$dt_factudmix["num_fac"]){
		imp_foot($bfac,$TotFac);
		impLn();
		$TotFac=NULL;
		$bfac=$dt_factudmix["num_fac"];
	}
	imp_detFac($dt_factudmix);
	llenaTotales($dt_factudmix,$TotFac);
	if($dt_factudmix["sub_ven"]!=0) llenaTotalGeneral($dt_factudmix,$TotGen);
}
imp_foot($bfac,$TotFac);
impLn();
imp_totalGeneral($TotGen);


/******** Funciones de Llenado de Datos ********/
function llenaTotales($dt_factudmix,&$sumTotFac){
	$sumTotFac["codCli"]=$dt_factudmix["codCli"];
	$sumTotFac["nomCli"]=$dt_factudmix["nomCli"];
	$sumTotFac["subVen"]=$dt_factudmix["sub_ven"];
	$sumTotFac["tipFac"]=$dt_factudmix["tip_fac"];
	$sumTotFac["tipVen"]=$dt_factudmix["des_tipven"];
	
	$sumTotFac["importe"] +=$dt_factudmix["subtotal"];
	$sumTotFac["iva"] +=$dt_factudmix["iva_pre"];
	$sumTotFac["totalFactura"] +=$dt_factudmix["total_cd"];
	//$sumTotFac["costoUnitario"] +=$dt_factudmix["cos_ref"];
	$sumTotFac["costoTotal"] +=$dt_factudmix["cos_tot"];
	$sumTotFac["utilidad"] +=$dt_factudmix["utilidad"];
}

function llenaTotalGeneral($dt_factudmix,&$sumTotGen){
	$tipventa=$dt_factudmix["tip_ven"];
	$sumTotGen[$tipventa]["descripcion"] = $dt_factudmix["des_tipven"];
	$sumTotGen[$tipventa]["costo"] +=$dt_factudmix["cos_tot"];
	$sumTotGen[$tipventa]["venta"] +=$dt_factudmix["subtotal"];
	$sumTotGen[$tipventa]["iva"] +=$dt_factudmix["iva_pre"];
}

/*********Funciones de Impresion de Datos**********/
function imp_head($dt_factudmix){
	global $pdf;
	$pdf->Cell(8,3,'',0,0,'C');
	$pdf->Cell(259,3,$dt_factudmix["des_tipven"].'    Fecha:'.chfecha($dt_factudmix["fec_fac"],'Y-m-d','d/m/Y'),0,1,'C',1);
}

function impLn(){
	global $pdf;
	$pdf->Ln(3);
}
function imp_foot($leyenda,$sumTotFac){
	global $pdf;
	$pdf->SetFont('Arial','B',8);
	if ($sumTotFac["subVen"]==0) $nom_cli = ' C   A   N   C   E   L   A   D   A ';
	else{
		//$dt_catcli=mysqli_fetch_array(mysqli_query($GLOBALS['con'] ,"SELECT * FROM dgcatcli where cod_cli = $sumTotFac['codigoCliente']"));
		$nom_cli = substr($sumTotFac["codCli"].'-'.$sumTotFac["nomCli"],0,100);
	}
	if($sumTotFac["importe"]!=0) $porUtilidad=($sumTotFac["utilidad"]/$sumTotFac["importe"])*100;
	$pdf->Cell(8,0.1,'',0,0,'C',0);
	$pdf->Cell(259,0.1,'',0,1,'C',1);
	$pdf->Cell(8,3,'',0,0,'C');
	$pdf->Cell(144,3,$sumTotFac["tipFac"].$leyenda.'  '.$sumTotFac["tipVen"].'>>'.$nom_cli,0,0,'L',0);
	$pdf->Cell(17,3,number_format($sumTotFac["importe"],2,'.',','),0,0,'R',0);
	$pdf->Cell(17,3,number_format($sumTotFac["iva"],2,'.',','),0,0,'R',0);
	$pdf->Cell(17,3,number_format($sumTotFac["totalFactura"],2,'.',','),0,0,'R',0);
	$pdf->Cell(15,3,'',0,0,'C',0);
	$pdf->Cell(17,3,number_format($sumTotFac["costoTotal"],2,'.',','),0,0,'R',0);
	$pdf->Cell(15,3,number_format($sumTotFac["utilidad"],2,'.',','),0,0,'R',0);
	$pdf->Cell(17,3,number_format($porUtilidad,2,'.',',').'%',0,1,'R',0);
	$pdf->SetFont('Arial','',8);
}

function imp_totalGeneral($sumTotGen){
	global $pdf;
	$pdf->Cell(14.5,3,'',0,0,'C',0);
	$pdf->Cell(20,3,'CVE. ',1,0,'C',1);
	$pdf->Cell(70,3,'Descripcion',1,0,'C',1);
	$pdf->Cell(20,3,'Costo',1,0,'C',1);
	$pdf->Cell(20,3,'Venta',1,0,'C',1);
	$pdf->Cell(20,3,'I.V.A.',1,0,'C',1);
	$pdf->Cell(20,3,'Utilidad',1,0,'C',1);
	$pdf->Cell(20,3,'%Utilidad Prom.',1,1,'C',1);
	while(@list($clave,$des) = each($sumTotGen)){
		$pdf->Cell(14.5,3,'',0,0,'C');
		$pdf->Cell(20,3,$clave,0,0,'C',0);
		$pdf->Cell(70,3,$des["descripcion"],0,0,'C',0);
		$pdf->Cell(20,3,number_format($des["costo"],2,'.',','),0,0,'R',0);
		$pdf->Cell(20,3,number_format($des["venta"],2,'.',','),0,0,'R',0);
		$pdf->Cell(20,3,number_format($des["iva"],2,'.',','),0,0,'R',0);
		$pdf->Cell(20,3,number_format($des["venta"]-$des["costo"],2,'.',','),0,0,'R',0);
		$pdf->Cell(20,3,number_format(($des["venta"]-$des["costo"])*100/$des["venta"],2,'.',','),0,1,'R',0);
		$stot[0] +=$des["costo"];
		$stot[1] +=$des["venta"];
		$stot[2] +=$des["iva"];
		$stot[3] +=$des["venta"]-$des["costo"];
	}
	$pdf->Cell(14.5,0.1,'',0,0,'C',0);
	$pdf->Cell(150,0.1,'',0,1,'C',1);
	$pdf->Cell(14.5,3,'',0,0,'C');
	$pdf->Cell(90,3,'Total:',0,0,'R',0);
	$pdf->Cell(20,3,number_format($stot[0],2,'.',','),0,0,'R',0);
	$pdf->Cell(20,3,number_format($stot[1],2,'.',','),0,0,'R',0);
	$pdf->Cell(20,3,number_format($stot[2],2,'.',','),0,0,'R',0);
	$pdf->Cell(20,3,number_format($stot[3],2,'.',','),0,0,'R',0);
	$pdf->Cell(20,3,number_format(($stot[1]-$stot[0])*100/$stot[1],2,'.',','),0,1,'R',0);
}

function imp_detFac($dt_factudmix){
	global $pdf;
	
	if($dt_factudmix["subtotal"]!=0) $porutilidad=($dt_factudmix["utilidad"]/$dt_factudmix["subtotal"])*100;
	$pdf->Cell(8,3,'',0,0,'L');
	$pdf->Cell(17,3,$dt_factudmix["num_fac"],0,0,'L',0);
	$pdf->Cell(20,3,$dt_factudmix["nparte1"],0,0,'L',0);
	$pdf->Cell(65,3,substr(trim($dt_factudmix["np_desc1"]),0,35),0,0,'L',0);
	$pdf->Cell(15,3,$dt_factudmix["cod_ven"],0,0,'L',0);
	$pdf->Cell(10,3,$dt_factudmix["can_ref"],0,0,'L',0);
	$pdf->Cell(17,3,number_format($dt_factudmix["pre_uni"],2,'.',','),0,0,'R',0);
	$pdf->Cell(17,3,number_format($dt_factudmix["subtotal"],2,'.',','),0,0,'R',0);
	$pdf->Cell(17,3,number_format($dt_factudmix["iva_pre"],2,'.',','),0,0,'R',0);
	$pdf->Cell(17,3,number_format($dt_factudmix["total_cd"],2,'.',','),0,0,'R',0);
	$pdf->Cell(15,3,number_format($dt_factudmix["cos_ref"],2,'.',','),0,0,'R',0);
	$pdf->Cell(17,3,number_format($dt_factudmix["cos_tot"],2,'.',','),0,0,'R',0);
	$pdf->Cell(15,3,number_format($dt_factudmix["utilidad"],2,'.',','),0,0,'R',0);
	$pdf->Cell(17,3,number_format($porutilidad,2,'.',','),0,1,'R',0);
}

$pdf->Output("Listado_de_Ventas_X_Cliente.pdf","D");
?>