<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
include("../../almacen/JQUERY.inc");

error_reporting(E_ALL);
session_start();
$_SESSION['detalle'] = array();

require_once 'Config/conexion.php';
require_once 'Model/Proyecto.php';
$objProyecto = new proyectos();
$resultado_proyecto = $objProyecto->get();
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <title>PEDIDOS</title>

        <!-- Bootstrap -->
        <link href="libs/css/bootstrap.css" rel="stylesheet">
        <script src="libs/js/jquery.js"></script>
        <script src="libs/js/jquery-1.8.3.min.js"></script>
        <script src="libs/js/jquery-ui.min.js"></script>
        <script src="libs/js/bootstrap.min.js"></script>
        <script type="text/javascript" language="JavaScript1.2" src="../../almacen/DSSCRIPT.js"></script>


        <script type="text/javascript" src="libs/ajax.js"></script>

        <!-- Alertity -->

        <link rel="stylesheet" href="libs/css/jquery-ui.min.css" />

        <link rel="stylesheet" href="libs/js/alertify/themes/alertify.core.css" />
        <link rel="stylesheet" href="libs/js/alertify/themes/alertify.bootstrap.css" id="toggleCSS" />
        <script src="libs/js/alertify/lib/alertify.min.js"></script>
        <style >
            label.modal, input.modal {
                display:block; text-transform: lowercase;
            }
            h1 { 
                font-size: 1.2em; margin: .6em 0; 
            }
            input.text , select.text { 
                margin-bottom:12px; width:95%; padding: .4em;  
            }
            fieldset {
                padding:0; border:0; margin-top:25px; 
            }
            div#users-contain { 
                width: 350px; margin: 20px 0; 
            }
            div#users-contain table { 
                margin: 1em 0; border-collapse: collapse; width: 100%; 
            }
            div#users-contain table td, div#users-contain table th { 
                border: 1px solid #eee; padding: .6em 10px; text-align: left;
            }
            .ui-dialog .ui-state-error { 
                padding: .3em; 
            }
            .validateTips { 
                border: 1px solid transparent; padding: 0.3em; 
            }
            form input.text{
                text-transform: uppercase;
            }
        </style>

        <script>

            $(function () {
                $("#dialog-form").dialog({
                    autoOpen: false,
                    height: 400,
                    width: 500,
                    modal: true,
                    buttons: {
                        "GUARDAR": add,
                        CANCELAR: function () {
                            $("#dialog-form").dialog("close");

                        }
                    }
                });

                function add() {
                    //alert("llego");
                    var descripcion = $("#descripcionP").val();
                    var calle = $("#calleP").val();
                    var numero = $("#numeroP").val();
                    var colonia = $("#coloniaP").val();
                    var estado = $("#estadoP").val();
                    var cp = $("#cpP").val();
                    var num = 5;
                    if (descripcion != "" || calle != "" || numero != "" || colonia != "" || estado != "" || cp != "") {

                        var parametros = {descripcion: descripcion, calle: calle, numero: numero, colonia: colonia, estado: estado, cp: cp, num: num}
                        $.ajax({
                            url: "Controller/ProyectoController.php",
                            type: "POST",
                            dataType: "json",
                            data: parametros
                        }).done(function (data) {
                            //alert(data.mensaje);
                            $( "#dialog-form" ).dialog( "close" );
                             window.location.reload();
                           
                        })
                          

                    } else {
                        alertify.error('No dejar campos en blanco');
                    }

                }


                $("#addProyecto").button().on("click", function () {
                    $("#dialog-form").dialog("open");
                });
                
               $("#txt_cantidad").keypress(function (e) {
                    var keycode = (e.keyCode ? e.keyCode : e.which);
                    if (keycode == '13') {
             
                        $( ".btn-agregar-producto" ).trigger( "click" );

                    }
                });

               
            });
        </script>

    </head>

    <body>
        <div class="container">

            <div class="page-header">
                <h1>Solicitud de Pedido al Almacen</h1>
            </div>
            <div class="row">
                <div class="col-md-10">	
                    Seleccione el proyecto:
                    <select name="cbo_proy" id="cbo_proy" class="col-md-2 form-control" onchange="selproy(this.value)">
                        <option value="0">Seleccione un proyecto</option>
                        <?php foreach ($resultado_proyecto as $proy): ?>
                            <option value="<?php echo $proy['nparte1'] ?>"><?php echo $proy['np_desc1'] ?></option>
                        <?php endforeach; ?>
                    </select>

                </div>
                <div class="col-md-2" style="top:20px;">


                    <button type="button" id="addProyecto" class="btn btn-primary">AGREGAR</button>

                </div>
            </div>
            <br/>
            <div class="row" style="display:none" id="busqueda">

                <div class="col-md-4">
                    <div>Producto:
                        <input id="descrip" name="descrip" type="text" class="col-md-2 form-control" placeholder="Nombre de Producto" autocomplete="off" />

                    </div>
                </div>
                <div class="col-md-2">
                    <div> id Producto: 
                        <input id="nparte1" name="nparte1" type="text" class="col-md-2 form-control" placeholder="id" autocomplete="off" readonly="" />
                    </div>
                </div>
                <div class="col-md-3">
                    <div>Cantidad:
                        <input id="txt_cantidad" name="txt_cantidad"  type="number" class="col-md-2 form-control" placeholder="Ingrese cantidad" autocomplete="off" />
                    </div>
                </div>
                <div class="col-md-2">
                    <div style="margin-top: 19px;">
                        <button type="button" class="btn btn-success btn-agregar-producto">Agregar</button>
                    </div>
                </div>
            </div>

            <br>
            <div class="panel panel-info">
                <div class="panel-heading">
                    <div class="row">  
                        <div class="col-md-2"> <h3 class="panel-title ">Productos</h3></div>
                        <div class="col-md-7"></div>
                        <button type="button" class="btn btn-sm btn-default guardar-enviar-carrito col-md-3">Guardar y Enviar</button>
                    </div>	
                </div>
                <div class="panel-body detalle-producto">
                    <?php if (count($_SESSION['detalle']) > 0) { ?>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Descripci&oacute;n</th>
                                    <th>Cantidad</th>
                                    <th>Precio</th>
                                    <th>Subtotal</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($_SESSION['detalle'] as $k => $detalle) {
                                    ?>
                                    <tr>
                                        <td><?php echo $detalle['producto']; ?></td>
                                        <td><?php echo $detalle['cantidad']; ?></td>
                                        <td><?php echo $detalle['precio']; ?></td>
                                        <td><?php echo $detalle['subtotal']; ?></td>
                                        <td><button type="button" class="btn btn-sm btn-danger eliminar-producto" id="<?php echo $detalle['id']; ?>">Eliminar</button></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    <?php } else { ?>
                        <div class="panel-body"> No hay productos agregados</div>
                    <?php } ?>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 text-right">

                </div>
            </div>
        </div>
        <!-- modal -->
        <div id="dialog-form" title="NUEVO">
            <form>
                <fieldset>
                    <label for="descripcionP">DESCRIPCION: </label>
                    <input type="text" name="descripcionP" id="descripcionP"  class="text ui-widget-content ui-corner-all" required>
                    
                    <label for="cpP">C.P: </label>
                    <input type="number" name="cpP" id="cpP"  class="text ui-widget-content ui-corner-all" required>
                    
                    

                    <label for="calleP">CALLE: </label>
                    <input type="text" name="calleP" id="calleP"  class="text ui-widget-content ui-corner-all" required>
                    

                    <label for="numeroP">NUMERO: </label>
                    <input type="number" name="numeroP" id="numeroP"  class="text ui-widget-content ui-corner-all" required>

                    <label for="coloniaP">COLONIA: </label>
                    <input type="text" name="coloniaP" id="coloniaP"  class="text ui-widget-content ui-corner-all" required>

                    <label for="estadoP">ESTADO: </label>
                    <input type="text" name="estadoP" id="estadoP"  class="text ui-widget-content ui-corner-all" required>

                    

                    <!-- Allow form submission with keyboard without duplicating the dialog button -->
                    <!-- <input type="submit" tabindex="-1" style="position:absolute; top:-1000px"> -->
                </fieldset>
            </form>
        </div>

        <!-- modal -->
    </body>
</html>
