<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
if (isset($_GET["page"])) {
    $page = $_GET["page"];
} else {
    $page = 0;
}

require_once '../Config/conexion.php';
require_once '../Model/Producto.php';
require_once '../Model/Proyecto.php';

switch ($page) {



    case 1:
        $objProducto = new farticulos();
        $json = array();
        $json['msj'] = 'Herramienta Agregada ';
        $json['success'] = true;
        if (isset($_POST['nparte1H']) && $_POST['nparte1H'] != '' && isset($_POST['cantidadH']) && $_POST['cantidadH'] != '') {
            try {
                $cantidadH = $_POST['cantidadH'];
                $nparte1H = $_POST['nparte1H'];

                $resultado_producto = $objProducto->getById($nparte1H);
                $producto = $resultado_producto->fetchObject();
                $descripcion = $producto->descripcion;
                $cantidadExistencias = $producto->cantidad;

                if ($cantidadH > $cantidadExistencias) {

                    $json['msj'] = 'No puede ingresar una cantidad mayor a la existencia ';
                    $json['success'] = false;
                    echo json_encode($json);
                } else {
                    $cantidadNueva = $cantidadExistencias - $cantidadH;
                    $objProducto->setCan($nparte1H,$cantidadNueva);

                    $_SESSION['detalle'][$nparte1H] = array('id' => $nparte1H, 'producto' => $descripcion, 'cantidad' => $cantidadH);

                    echo json_encode($json);
                }
                //die(json_encode(array('a'=>$nparte1H, 'b'=> $cantidadH , 'c'=>$descripcion)));
            } catch (PDOException $e) {
                $json['msj'] = $e->getMessage();
                $json['success'] = false;
                echo json_encode($json);
            }
        } else {
            $json['msj'] = 'Ingrese un producto y/o ingrese cantidad ';
            $json['success'] = false;
            echo json_encode($json);
        }

        break;

    case 2:
        $objProducto = new farticulos();
        $json = array();
        $json['msj'] = 'Producto Eliminado';
        $json['success'] = true;

        if (isset($_POST['id'])) {
            try {
               foreach($_SESSION['detalle'] as $k => $detalle){
                   if($_POST['id'] == $detalle['id']){
                         $cantidadDovolver = $detalle["cantidad"];
                         break;
                   }
               }
                unset($_SESSION['detalle'][$_POST['id']]);
                $resultado_producto = $objProducto->getById($_POST['id']);
                $producto = $resultado_producto->fetchObject();
                $cantidadExistencias = $producto->cantidad;
                $nuevaCantidad = $cantidadExistencias + $cantidadDovolver;
                $objProducto->setCan($_POST['id'],$nuevaCantidad);
                
                $json['success'] = true;
                
               

                echo json_encode($json);
            } catch (PDOException $e) {
                $json['msj'] = $e->getMessage();
                $json['success'] = false;
                echo json_encode($json);
            }
        }
        break;

    case 4:
        $objProducto = new farticulos();
        $objProy = new proyectos();
        $json = array();
        $json['msj'] = 'Guardado correctamente';
        $json['success'] = true;
        $json['idventa'] = '';

        if (count($_SESSION['detalle']) > 0) {
            try {
                $objProducto->guardarVenta($_POST['proy'], $_POST["supervisor"]);
                $registro_ultima_venta = $objProducto->getUltimaVenta();
                $result_ultima_venta = $registro_ultima_venta->fetchObject();
                $idventa = $result_ultima_venta->ultimo;
                foreach ($_SESSION['detalle'] as $detalle):
                    $idproducto = $detalle['id'];
                    $cantidad = $detalle['cantidad'];
                    $objProducto->guardarDetalleVenta($idventa, $idproducto, $cantidad);
                endforeach;

                $_SESSION['detalle'] = array();

                $json['success'] = true;
                $json['idventa'] = $idventa;

                echo json_encode($json);
            } catch (PDOException $e) {
                $json['msj'] = $e->getMessage();
                $json['success'] = false;
                echo json_encode($json);
            }
        } else {
            $json['msj'] = 'No hay productos agregados';
            $json['success'] = false;
            echo json_encode($json);
        }
        break;
}
?>
