<?php

require '../../almacen/fpdf/fpdf.php';
include("../../DMMYSQLG.php");

class PDF extends FPDF {

    function Header() {
        include("../../almacen/DYIM_VER.php");
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(30);
        $this->Cell(230, 0, utf8_decode('PRESTAMOS'), 0, 1, 'C');
        #$this->Cell(40, 10, 'FECHA: '.date('d/m/Y'), 0, 1, 'C');
        $this->Ln(15);
    }

    function Footer() {
        //Posicin: a 1,5 cm del final
        $this->SetY(-15);
        //Arial italic 8
        $this->SetFont('Arial', 'I', 8);
        //Nmero de pgina
        $this->Cell(0, 10, $this->PageNo(), 0, 0, 'C');
    }

}

if ($_POST["fechaIni"] == NULL || $_POST["fechaFin"] == NULL) {

    $idProyecto = $_POST["cbo_proy"];

    $idPedidos = mysqli_query($GLOBALS['con'] ,"select fdepartamento.np_desc1, fdepartamento.nparte1, id from pedidosH
inner join fdepartamento on pedidosH.proyecto=fdepartamento.nparte1 
where proyecto = $idProyecto  ORDER BY fdepartamento.np_desc1 ASC  ");
} else {

    if ($_POST["cbo_proy"] == 0) {
        $fechaIni = DateTime::createFromFormat('d/m/Y', $_POST["fechaIni"]);
        $fechaFin = DateTime::createFromFormat('d/m/Y', $_POST["fechaFin"]);
        $fechaIni2 = $fechaIni->format('Y-m-d');
        $fechaFin2 = $fechaFin->format('Y-m-d');

        $idPedidos = mysqli_query($GLOBALS['con'] ,"select fdepartamento.np_desc1, fdepartamento.nparte1, id from pedidosH
inner join fdepartamento on pedidosH.proyecto=fdepartamento.nparte1 
where fecha_sol between '$fechaIni2' and '$fechaFin2'  ORDER BY fdepartamento.np_desc1 ASC  ");
    } else {

        $fechaIni = DateTime::createFromFormat('d/m/Y', $_POST["fechaIni"]);
        $fechaFin = DateTime::createFromFormat('d/m/Y', $_POST["fechaFin"]);
        $fechaIni2 = $fechaIni->format('Y-m-d');
        $fechaFin2 = $fechaFin->format('Y-m-d');
        $idProyecto = $_POST["cbo_proy"];
        $idPedidos = mysqli_query($GLOBALS['con'] ,"select fdepartamento.np_desc1, fdepartamento.nparte1, id from pedidosH
inner join fdepartamento on pedidosH.proyecto=fdepartamento.nparte1 
where fecha_sol between '$fechaIni2' and '$fechaFin2' AND pedidosH.proyecto = $idProyecto  ORDER BY fdepartamento.np_desc1 ASC  ");
    }
}

$costoPromedio;
$cantidadSurtida;

$pdf = new PDF('L', 'mm', 'A4');
$pdf->AddPage();
$pdf->SetFont('Arial', '', 10);

$contador = 0;
$pilaIni = 0;
$pilaFin = 1;

$pila = array();

while ($fila = mysqli_fetch_assoc($idPedidos)) {
    $idP = $fila["id"];
    $nombreProyecto = $fila["np_desc1"];
    $proyecto = $fila["nparte1"];
    array_push($pila, $proyecto);

    $pedidos = mysqli_query($GLOBALS['con'] ,"select det_pedidosH.nparte1,cant_sol,cant_sur,activo_fijo.descripcion,activo_fijo.precio 
from det_pedidosH inner join activo_fijo on det_pedidosH.nparte1=activo_fijo.id
where id_pedido = $idP ");

    if ($GLOBALS['con']tador > 0) {
        if ($pila[$pilaIni] == $pila[$pilaFin]) {
            $pilaIni++;
            $pilaFin++;
        } else {
            $pdf->Ln(5);
            $pdf->cell(60, 6, $nombreProyecto, 0, 1, 'C');
            $pdf->cell(10, 6, 'ID', 1, 0, 'C');
            $pdf->cell(13, 6, 'No', 1, 0, 'C');
            $pdf->cell(180, 6, 'Descripcion', 1, 0, 'C');
            $pdf->cell(30, 6, 'H.PRESTADAS', 1, 0, 'C');
            $pdf->cell(30, 6, 'H.DEVUELTAS', 1, 0, 'C');
            $pdf->cell(20, 6, 'PERDIDA', 1, 1, 'C');
            $pilaIni++;
            $pilaFin++;
        }
    } else {

        $pdf->cell(60, 6, $nombreProyecto, 0, 1, 'C');
        $pdf->cell(10, 6, 'ID', 1, 0, 'C');
        $pdf->cell(13, 6, 'No', 1, 0, 'C');
        $pdf->cell(180, 6, 'Descripcion', 1, 0, 'C');
        $pdf->cell(30, 6, 'H.PRESTADAS', 1, 0, 'C');
        $pdf->cell(30, 6, 'H.DEVUELTAS', 1, 0, 'C');
        $pdf->cell(20, 6, 'PERDIDA', 1, 1, 'C');
    }



    while ($row = mysqli_fetch_assoc($pedidos)) {
        $nombreArticulo = substr($row["descripcion"], 0, 125);
        $costoPromedio = $row["precio"];
        $herramientasD =  $row["cant_sol"];
        $cantidadSurtida = $row["cant_sur"];
        $pdf->cell(10, 6, $idP, 1, 0, 'C');
        $pdf->cell(13, 6, $row["nparte1"], 1, 0, 'C');
        $pdf->setFont('Arial', '', 8);
        $pdf->cell(180, 6, $nombreArticulo, 1, 0, 'L');
        $pdf->setFont('Arial');
        $pdf->cell(30, 6, $row["cant_sol"], 1, 0, 'C');
        $pdf->cell(30, 6, $row["cant_sur"], 1, 0, 'C');
        $pdf->cell(20, 6, '$ ' . ($herramientasD - $cantidadSurtida)* $costoPromedio, 1, 1, 'C');
    }
    $contador = 1;
}




$pdf->Output("Prestamos.pdf","D");
