<?php ?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Empleados</title>
     
        <link href="../css/crud/color.css" rel="stylesheet" type="text/css"/>
        <link href="../css/crud/easyui.css" rel="stylesheet" type="text/css"/>
        <link href="../css/crud/general.css" rel="stylesheet" type="text/css"/>
        <link href="../css/crud/icon.css" rel="stylesheet" type="text/css"/>
         
        <script src="../js/jquery.min.js" type="text/javascript"></script>
        <script src="../js/jquery.easyui.min.js" type="text/javascript"></script>
         
    </head>
    <body>
        <p align="center"><img src="../css/crud/icons/users.png" width="20px" height="20px"/> </p>
        <h2 style="text-align:center">Empleados</h2>
                
        <table id="dg" title="Empleados" class="easyui-datagrid" style="width:100%;height:380px"
               url="get_data.php"
               toolbar="#toolbar" pagination="true"
               rownumbers="true" fitColumns="true" singleSelect="true">
            <thead>
                <tr>
                    <th field="num_empleado" width="25">Num Empleado</th>
                    <th field="nombre" width="50">Nombre</th>
                    <th field="correo" width="50">Correo</th>
                    <th field="jefe_directo" width="50">Jefe Directo</th>
                </tr>
            </thead>
        </table>
        <div id="toolbar">
            <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="newData()">Nuevo Empleado</a>
            <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editData()">Editar Empleado</a>
            <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="destroyData()">Eliminar Empleado</a>
        </div>

        <div id="dlg" class="easyui-dialog" style="width:400px;height:340px;padding:10px 20px"
             closed="true" buttons="#dlg-buttons">
            <div class="ftitle">Informacion Empleado</div>
            <form id="fm" method="post" novalidate>
                <div class="fitem">
                    <label>Num Empleado:</label>
                    <input name="num_empleado" class="easyui-textbox" required="true">
                </div>
                <div class="fitem">
                    <label>Nombre:</label>
                    <input name="nombre" class="easyui-textbox" required="true">
                </div>
                <div class="fitem">
                    <label>Correo:</label>
                    <input name="correo" class="easyui-textbox">
                </div>
                <div class="fitem">
                    <label>Jefe Directo:</label>
                    <input name="jefe_directo" class="easyui-textbox" required="">
                </div>       
            </form>
        </div>
        <div id="dlg-buttons">
            <a href="javascript:void(0)" class="easyui-linkbutton c6" iconCls="icon-ok" onclick="saveData()" style="width:90px">Guardar</a>
            <a href="javascript:void(0)" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlg').dialog('close')" style="width:90px">Cancelar</a>
        </div>
        <script type="text/javascript">
            var url;
            function newData() {
                $('#dlg').dialog('open').dialog('setTitle', 'Nuevo Empleado');
                $('#fm').form('clear');
                url = 'save_data.php';
            }
            function editData() {
                var row = $('#dg').datagrid('getSelected');
                if (row) {
                    $('#dlg').dialog('open').dialog('setTitle', 'Editar Empleado');
                    $('#fm').form('load', row);
                    url = 'update_data.php?id=' + row.id;
                }
            }
            function saveData() {
                $('#fm').form('submit', {
                    url: url,
                    onSubmit: function () {
                        return $(this).form('validate');
                    },
                    success: function (result) {
                        var result = eval('(' + result + ')');
                        if (result.errorMsg) {
                            $.messager.show({
                                title: 'Error',
                                msg: result.errorMsg
                            });
                        } else {
                            $('#dlg').dialog('close');		// close the dialog
                            $('#dg').datagrid('reload');	// reload the user data
                        }
                    }
                });
            }
            function destroyData() {
                var row = $('#dg').datagrid('getSelected');
                if (row) {
                    $.messager.confirm('Confirmar', 'Estas seguro que quieres eliminar este Empleado?', function (r) {
                        if (r) {
                            $.post('destroy_data.php', {id: row.id}, function (result) {
                                if (result.success) {
                                    $('#dg').datagrid('reload');	// reload the user data
                                } else {
                                    $.messager.show({// show error message
                                        title: 'Error',
                                        msg: result.errorMsg
                                    });
                                }
                            }, 'json');
                        }
                    });
                }
            }
        </script>
        <style type="text/css">
            #fm{
                margin:0;
                padding:10px 30px;
            }
            .ftitle{
                font-size:14px;
                font-weight:bold;
                padding:5px 0;
                margin-bottom:10px;
                border-bottom:1px solid #ccc;
            }
            .fitem{
                margin-bottom:15px;
            }
            .fitem label{
                display:inline-block;
                width:80px;
            }
            .fitem input{
                width:160px;
            }

            .fitem1{
                margin-bottom:5px;
                margin-top:10px;
            }
            .fitem1 label{
                display:inline-block;
                width:80px;
            }
            .fitem1 input{
                width:30px;
                margin-left: 50px;
            }

        </style>
    </body>
</html>
